<?php 
include ('includes/header.php');
$table_name = 'leagueshift';
$page_name = 'leagues_timeshift';

// Insert initial data if the table is empty
$data = ['cla' => '+', 'time' => '0'];
$db->insertIfEmpty($table_name, $data);

// Retrieve the existing data for display
$res = $db->select($table_name, '*', '', '');

// Handle form submission
if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;
    $db->update($table_name, $updateData, 'id = :id', [':id' => 1]);
    echo "<script>window.location.href='". $page_name.".php?status=1'</script>";
}

// Set default values for form fields based on current database values
$currentCla = $res[0]['cla'] ?? '+';
$currentTime = $res[0]['time'] ?? '0';
?>

<div class="col-md-6 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> Leagues timeshift</h2>
                </center>
            </div>
            
            <div class="card-body">
                <form method="post">
                    <div class="form-group ctinput">
                        <label class="form-label">Select the time shift method </label>
                        <select id="cla" name="cla">
                            <option value="+" <?= $currentCla == '+' ? 'selected' : '' ?>>Increase time</option>
                            <option value="-" <?= $currentCla == '-' ? 'selected' : '' ?>>Reduce time</option>
                        </select>
                    </div>
                    <div class="form-group ctinput">
                        <label class="form-label">Add in minutes [Example : 1 hour = 60 minutes | 1.5 hours = 90 minutes]</label>
                        <input class="form-control" id="time" name="time" value="<?= htmlspecialchars($currentTime) ?>" type="text"/>
                    </div>
                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include ('includes/footer.php');?>
